﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.request.signfile.document;
using WindowsFormsApp1.Factory.response.signfile.document;

namespace WindowsFormsApp1.Factory.signfile.documents
{
    class CreateDocuments : EsignRequest<CreateDocumentsResponse>
    {
        public CreateDocuments(string flowId, Docs docs)
        {
            this.flowId = flowId;
            this.docs = docs;
        }

        [JsonIgnore]
        public string flowId { set; get; }
        public Docs docs { set; get; }

        public CreateDocuments build()
        {
            this.Url = "/v1/signflows/" + flowId + "/documents";
            this.ReqType = HttpType.POST;
            return this;
        }

    }
}
