﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.response.signfile.signers;

namespace WindowsFormsApp1.Factory.signfile.signers
{
    [JsonObject(MemberSerialization.OptIn)]
    class GetFileSignUrl : EsignRequest<GetFileSignUrlResponse>
    {
        public string flowId;
        public string accountId;
        public string organizeId;
        public int? urlType;
        public string appScheme;

        public GetFileSignUrl(string flowId, string accountId)
        {
            this.flowId = flowId;
            this.accountId = accountId;
        }

        public GetFileSignUrl build() {
            StringBuilder url = new StringBuilder("/v1/signflows/" + flowId + "/executeUrl?accountId=" + accountId);
            if (organizeId != null)
            {
                url.Append("&organizeId=" + organizeId);
            }
            if (urlType != null)
            {
                url.Append("&urlType=" + urlType);
            }
            if (appScheme != null)
            {
                url.Append("&appScheme=" + appScheme);
            }
            base.Url = url.ToString();
            base.ReqType = HttpType.GET;
            return this;
        }
    }
}
