﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.request.signfile.signfields;
using WindowsFormsApp1.Factory.response.signfile.signfields;

namespace WindowsFormsApp1.Factory.signfile.signfields
{
    class CreateHandSign : EsignRequest<CreateHandSignResponse>
    {
        [JsonIgnore]
        public string flowId;
        public Signfields signfields;

        public CreateHandSign(string flowId, Signfields signfields)
        {
            this.flowId = flowId;
            this.signfields = signfields;
        }

        public CreateHandSign build()
        {
            base.Url = "/v1/signflows/" + flowId + "/signfields/handSign";
            base.ReqType = HttpType.POST;
            return this;
        }
    }
}
