﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.request.signfile.signfields;
using WindowsFormsApp1.Factory.response.signfile.signfields;

namespace WindowsFormsApp1.Factory.signfile.signfields
{
    class CreatePlatformSign : EsignRequest<CreatePlatformSignResponse>
    {
        [JsonIgnore]
        public string flowId;
        public Signfields signfields;

        public CreatePlatformSign(string flowId, Signfields signfields)
        {
            this.flowId = flowId;
            this.signfields = signfields;
        }

        public CreatePlatformSign build() {
            base.Url = "/v1/signflows/" + flowId + "/signfields/platformSign";
            base.ReqType = HttpType.POST;
            return this; 
        }
    }
}
