﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.request.signfile.signflows;
using WindowsFormsApp1.Factory.response.signfile.signflows;

namespace WindowsFormsApp1.Factory.signfile.signflows
{
    class CreateSignFlow : EsignRequest<CreateSignFlowResponse>
    {
        public CreateSignFlow(string businessScene)
        {
            this.businessScene = businessScene;
        }

        public bool autoArchive { get; set; }
        public string businessScene { get; set; }
        public ConfigInfo configInfo { get; set; }
        public int? contractValidity { get; set; }
        public int? contractRemind { get; set; }
        public int? signValidity { get; set; }
        public string initiatorAccountId { get; set; }
        public string initiatorAuthorizedAccountId { get; set; }

        public CreateSignFlow build()
        {
            this.Url = "/v1/signflows";
            this.ReqType = HttpType.POST;
            return this;
        }
    }
}
