﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using WindowsFormsApp1.Factory;
using WinTechWrapperDemo.demoUtils;
using WindowsFormsApp1.Factory.account;
using WindowsFormsApp1.Config;
using WindowsFormsApp1.Factory.response.account;
using WindowsFormsApp1.Factory.seals;
using WindowsFormsApp1.Factory.response.seals;
using WindowsFormsApp1.Factory.filetemp;
using WindowsFormsApp1.Factory.response.filetemp;
using WindowsFormsApp1.Factory.signfile.signflows;
using WindowsFormsApp1.Factory.request.signfile.signflows;
using WindowsFormsApp1.Factory.response.signfile.signflows;
using WindowsFormsApp1.Factory.signfile.documents;
using WindowsFormsApp1.Factory.request.signfile.document;
using WindowsFormsApp1.Factory.response.signfile.document;
using WindowsFormsApp1.Factory.signfile.signfields;
using WindowsFormsApp1.Factory.request.signfile.signfields;
using WindowsFormsApp1.Factory.response.signfile.signfields;
using WindowsFormsApp1.Factory.signfile.signers;
using WindowsFormsApp1.Factory.response.signfile.signers;

namespace WindowsFormsApp1
{
    public partial class FrmMain : Form
    {

        private void button3_Click(object sender, EventArgs e)
        {
            string thirdPartyUserId = "123123213213";
            CreatePersonByThirdPartyUserId createPerId = new CreatePersonByThirdPartyUserId(thirdPartyUserId, ParameterConfig.name, ParameterConfig.idType,ParameterConfig.idNumber);
            createPerId.mobile = ParameterConfig.mobile;
            createPerId.build();
            //创建个人账户
            string reqData = JSONHelper.EntityToJSON(createPerId);
            textBox2.Text = reqData;
            CreatePersonByThirdPartyUserIdResponse result = createPerId.Execute();
            textBox3.Text = result.body;
            
            Console.WriteLine("账号"+ result.data.accountId);
            Console.WriteLine("状态码" + result.status);
            Console.WriteLine("错误码"+result.code);
            Console.WriteLine("错误信息" + result.message);
            ParameterConfig.accountId = result.data.accountId;


            //textBox3.Text = result;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //创建个人模板印章
            CreatePersonalTemplate createPerTemSeal = new CreatePersonalTemplate(ParameterConfig.accountId, "RED", "SQUARE");
            CreatePersonalTemplateResponse result=createPerTemSeal.build().Execute();
            string reqData = JSONHelper.EntityToJSON(createPerTemSeal);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
            ParameterConfig.sealId = result.data.sealId;

        }

        private void button5_Click(object sender, EventArgs e)
        {
            //上传方式创建文件

            String contentMd5 = Core.GetFileInfo.GetContentMD5FromFile(ParameterConfig.filepath);
            int fileSize = Core.GetFileInfo.GetFileLength(ParameterConfig.filepath);
            GetFileUploadUrl getUrl=new GetFileUploadUrl(contentMd5,ParameterConfig.fileMime,false, ParameterConfig.fileName, fileSize);
            GetFileUploadUrlResponse result=getUrl.build().Execute();
            string reqData = JSONHelper.EntityToJSON(getUrl);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
            ParameterConfig.fileId = result.data.fileId;

            UploadFile upfile = new UploadFile(ParameterConfig.filepath, ParameterConfig.fileMime, result.data.uploadUrl);
            int res = upfile.Execute();
            textBox3.AppendText(res+"");

        }


        private void button6_Click(object sender, EventArgs e)
        {
            //创建签署流程
            //拼接创建签署流程JSON字符串，当作请求body体

            CreateSignFlow createSignFlow=new CreateSignFlow("文件主题");
            createSignFlow.autoArchive = true;
            ConfigInfo configInfo=new ConfigInfo();
            configInfo.noticeDeveloperUrl = ParameterConfig.noticeDeveloperUrl;
            configInfo.noticeType = "1";
            configInfo.redirectUrl = ParameterConfig.redirectUrl;
            configInfo.signPlatform = "1,2";
            createSignFlow.configInfo = configInfo;
            createSignFlow.initiatorAccountId = ParameterConfig.accountId;
            CreateSignFlowResponse result=createSignFlow.build().Execute();
            string reqData = JSONHelper.EntityToJSON(createSignFlow);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
            ParameterConfig.flowId=result.data.flowId;

        }

        private void button7_Click(object sender, EventArgs e)
        {
            //流程文档添加

            Docs docs=new Docs();
            Doc doc1=new Doc();
            doc1.fileId = ParameterConfig.fileId;
            doc1.fileName = "文档名称";
            docs.Add(doc1);
            CreateDocuments createDoc=new CreateDocuments(ParameterConfig.flowId, docs);
            CreateDocumentsResponse result=createDoc.build().Execute();
            string reqData = JSONHelper.EntityToJSON(createDoc);
            textBox2.Text = reqData;
            textBox3.Text = result.body;

        }

        private void button8_Click(object sender, EventArgs e)
        {
            //添加平台自动签署区
            Signfields signfields = new Signfields();
            Signfield signfield=new Signfield();
            signfield.fileId = ParameterConfig.fileId;
            signfield.order = "1";
            PosBean posBean=new PosBean();
            posBean.posPage = "1";
            posBean.posX = 500;
            posBean.posY = 500;
            posBean.addSignTime = true;
            signfield.posBean = posBean;
            signfield.signType = 1;
            signfield.thirdOrderNo = "12312312312312";
            signfields.Add(signfield);
            CreatePlatformSign createPlaForSign=new CreatePlatformSign(ParameterConfig.flowId, signfields);
            CreatePlatformSignResponse result=createPlaForSign.build().Execute();
            string reqData = JSONHelper.EntityToJSON(createPlaForSign);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
        }

        private void button9_Click(object sender, EventArgs e)
        {
            //添加手动盖章签署区
            Signfields signfields = new Signfields();
            Signfield signfield = new Signfield();
            signfield.fileId = ParameterConfig.fileId;
            signfield.order = "1";
            PosBean posBean = new PosBean();
            posBean.posPage = "1";
            posBean.posX = 300;
            posBean.posY = 300;
            posBean.addSignTime = true;
            signfield.posBean = posBean;
            signfield.signType = 1;
            signfield.signerAccountId = ParameterConfig.accountId;
            signfield.thirdOrderNo = "12312312312312312312";
            signfields.Add(signfield);
            CreateHandSign createHandSign=new CreateHandSign(ParameterConfig.flowId, signfields);
            CreateHandSignResponse result = createHandSign.build().Execute();
            string reqData = JSONHelper.EntityToJSON(createHandSign);
            textBox2.Text = reqData;
            textBox3.Text = result.body;


        }

        private void button10_Click(object sender, EventArgs e)
        {
            //开启签署流程
            StartSignFlow startSignFlow=new StartSignFlow(ParameterConfig.flowId);
            StartSignFlowResponse result=startSignFlow.build().Execute();
            string reqData = JSONHelper.EntityToJSON(startSignFlow);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
        }

        private void button11_Click(object sender, EventArgs e)
        {
            //获取签署地址
            GetFileSignUrl fileSignUrl=new GetFileSignUrl(ParameterConfig.flowId,ParameterConfig.accountId);
            fileSignUrl.organizeId = "0";
            GetFileSignUrlResponse result=fileSignUrl.build().Execute();
            string reqData = JSONHelper.EntityToJSON(fileSignUrl);
            textBox2.Text = reqData;
            textBox3.Text = result.body;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            DeletePersonByAccountId delPsnId=new DeletePersonByAccountId(ParameterConfig.accountId);
            DeletePersonByAccountIdResponse result=delPsnId.build().Execute();
            string reqData = JSONHelper.EntityToJSON(delPsnId);
            textBox2.Text = reqData;
            textBox3.Text = result.body;
        }

        public FrmMain()
        {
            InitializeComponent();
        }

    }
}
