﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;

namespace WinTechWrapperDemo.demoUtils
{
    public class DigestHelper
    {
        /// <summary>
        ///  HmacSHA256 加密
        /// </summary>
        /// <param name="secret">projectSecret</param>
        /// <param name="data">请求的JSON参数</param>
        /// <returns></returns>
        public static string GetSignature(string data, string secret)
        {
            byte[] keyByte = Encoding.UTF8.GetBytes(secret);
            byte[] messageBytes = Encoding.UTF8.GetBytes(data);
            using (var hmacsha256 = new HMACSHA256(keyByte))
            {
                byte[] hashmessage = hmacsha256.ComputeHash(messageBytes);
                StringBuilder sb = new StringBuilder();
                foreach (byte test in hashmessage)
                {
                    sb.Append(test.ToString("x2"));
                }
                return sb.ToString();
            }
        }

        #region 计算请求签名值
        /// <summary>
        /// HmacSHA256 计算请求签名值的Base64
        /// </summary>
        /// <param name="message"></param>
        /// <param name="secret"></param>
        /// <returns></returns>
        public static string doSignatureBase64(String message, String secret)
        {
            byte[] keyByte = Encoding.UTF8.GetBytes(secret);
            byte[] messageBytes = Encoding.UTF8.GetBytes(message);
            using (var hmacsha256 = new HMACSHA256(keyByte))
            {
                byte[] hashmessage = hmacsha256.ComputeHash(messageBytes);
                return Convert.ToBase64String(hashmessage); 
            }
        }
        #endregion

        #region 获取MD5
        /// <summary>
        /// 获取MD5
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string doContentMD5(String str)
        {
            string ContentMD5 = null;
            try
            {
                System.Security.Cryptography.MD5 md5 = new System.Security.Cryptography.MD5CryptoServiceProvider();
                byte[] data = md5.ComputeHash(Encoding.UTF8.GetBytes(str));
                ContentMD5 = Convert.ToBase64String(data).ToString();

            }
            catch (Exception ex)
            {
                MessageBox.Show("错误信息", "计算ContentMD5值时发生异常：" + ex.Message);

            }
            return ContentMD5;
        }
        #endregion



        /// <summary>
        /// 计算文件内容的MD5,其MD5值是一个128位（128bit）的二进制数组，对该数字进行base64编码为一个的Content-MD5值
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static string GetMD5FromStr(string message, bool MD5_Mode)
        {
            try
            {
                byte[] result = Encoding.UTF8.GetBytes(message);
                MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
                byte[] output = md5.ComputeHash(result);
                if (MD5_Mode == true)
                {
                    return BitConverter.ToString(output).Replace("-", "");//32位MD5值
                }
                else
                {
                    return BitConverter.ToString(output, 4, 8).Replace("-", "");//16位MD5值
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("错误信息", "计算MD5值时发生异常：" + ex.Message);
            }
            return null;
        }
    }
}
