﻿using log4net;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WinTechWrapperDemo.demoUtils
{
    public class FileHelper
    {
        private static ILog Logger = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// 将文件转换为byte数组
        /// </summary>
        /// <param name="path">文件地址</param>
        /// <returns>转换后的byte数组</returns>
        public static byte[] File2Bytes(string path)
        {
            if (!System.IO.File.Exists(path))
            {
                string message = String.Format("读取文件时发生异常:{0}不存在", path);
                Logger.Error(message);
                return new byte[0];
            }

            FileStream fs = null;
            byte[] buff = null;
            try
            {
                FileInfo fi = new FileInfo(path);
                buff = new byte[fi.Length];
                fs = fi.OpenRead();
                fs.Read(buff, 0, Convert.ToInt32(fs.Length));
                //fs.Close();
            }
            catch (Exception ex)
            {
                string message = String.Format("读取文件时发生异常:{0}", ex.Message);
                Logger.Error(message);
            }
            finally
            {
                if (null != fs)
                {
                    fs.Close();
                }
            }
            return buff;
        }


        /// <summary>
        /// 将PDF的Base64转换为文件并保存到指定地址
        /// </summary>
        /// <param name="buff">byte数组</param>
        /// <param name="savepath">保存地址</param>
        public static void SavePDFBase64AsFile(string pdfBase64, string savepath)
        {
            System.IO.MemoryStream stream = new System.IO.MemoryStream(Convert.FromBase64String(pdfBase64));
            byte[] bytes = stream.ToArray();
            // 将Byte数组转化PDF文件
            SaveBytesAsFile(bytes, savepath);

        }

        /// <summary>
        /// 将PDF的byte数组字符串转化为文件并保存到指定地址
        /// </summary>
        /// <param name="streamStr">byte数组字符串</param>
        /// <param name="savepath">保存地址</param>
        public static void SavePDFStreamAsFile(string streamStr, string savepath)
        {
            string arrayStream = streamStr.TrimStart('[').TrimEnd(']');
            string[] byteStreams = arrayStream.Split(',');
            int len = byteStreams.Length;
            byte[] bytes = new byte[len];
            // stream字符串还原Byte数组
            for (int i = 0; i < len; i++)
            {
                bytes[i] = (byte)Convert.ToInt32(byteStreams[i]);
            }
            // 将Byte数组转化PDF文件
            SaveBytesAsFile(bytes, savepath);
        }


        /// <summary>
        /// 将Byte数组转化为磁盘文件
        /// </summary>
        /// <param name="bytes">byte数组</param>
        /// <param name="savepath">保存地址</param>
        public static void SaveBytesAsFile(byte[] bytes, string savepath)
        {
            FileStream fs = null;
            BinaryWriter bw = null;
            try
            {
                fs = new FileStream(savepath, FileMode.Create);
                bw = new BinaryWriter(fs);
                bw.Write(bytes, 0, bytes.Length);
            }
            catch (Exception ex)
            {
                string exMsg = string.Format(">>>> 保存文件时发生异常:: {0}  StackTrace: {1}", ex.Message, ex.StackTrace);
                Logger.Error(exMsg);
                exMsg = string.Format(">>>> 保存文件时发生异常:: {0}", ex.Message);
                MessageBox.Show(exMsg, "Demo提示", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                if (null != bw)
                {
                    bw.Close();
                }
                if (null != fs)
                {
                    fs.Close();
                }
            }
        }
    }
}
