﻿using log4net;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;
using System.Windows.Forms;

/********************************************************************************

** 描述: 基于WebRequest/WebResponse组合调用HTTP接口的辅助类，仅供接口调试参考
** 日期: 2020/11/26

*********************************************************************************/

namespace WinTechWrapperDemo.demoUtils
{
    public class HttpHelper
    {
        private static ILog Logger = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
        #region GET 请求
        public HttpRespResult Get(string serviceUrl, string data, Dictionary<string, string> postHeaders, string contentType)
        {
            HttpWebRequest webReq = null;
            HttpWebResponse webResp = null;
            StreamReader reader = null;
            // HTTP响应状态码
            int respStatusCode = -1;
            // HTTP响应状态的描述性信息
            string respStatusCodeMsg = null;
            // 响应信息
            string respContent = string.Empty;
            // HTTP响应结果
            HttpRespResult httpRespResult = null;
            try
            {
                // 构造一个Web请求的对象
                webReq = (HttpWebRequest)WebRequest.Create(serviceUrl);
                if (null != postHeaders)
                {
                    //遍历字典
                    foreach (KeyValuePair<string, string> header in postHeaders)
                    {
                        webReq.Headers.Add(header.Key, header.Value);
                    }
                }
                webReq.Accept = contentType;
                webReq.ContentType = contentType;
                // 获取Web请求的响应内容
                webResp = (HttpWebResponse)webReq.GetResponse();
                // 获取 HTTP响应状态码
                respStatusCode = Convert.ToInt32(webResp.StatusCode);
                // 获取 HTTP响应状态的描述性信息
                respStatusCodeMsg = webResp.StatusCode.ToString();
                // 通过响应流构造一个StreamReader
                reader = new StreamReader(webResp.GetResponseStream(), Encoding.UTF8);
                // 利用 StreamReader 从头到尾读取响应内容
                respContent = reader.ReadToEnd();

                httpRespResult = new HttpRespResult();
                httpRespResult.IsNetworkSuccess = true;
                httpRespResult.NetworkMsg = "网络请求成功";
                httpRespResult.HttpStatusCode = respStatusCode;
                httpRespResult.HttpStatusCodeMsg = respStatusCodeMsg;
                httpRespResult.RespData = respContent;
            }
            catch (WebException webEx)
            {
                if (webEx.Status == WebExceptionStatus.ProtocolError)
                {
                    webResp = (HttpWebResponse)webEx.Response;
                    if (null != webResp)
                    {
                        // 获取 HTTP响应状态码
                        respStatusCode = Convert.ToInt32(webResp.StatusCode);
                        // 获取 HTTP响应状态的描述性信息
                        respStatusCodeMsg = webResp.StatusCode.ToString();

                        reader = new StreamReader(webResp.GetResponseStream(), Encoding.UTF8);
                        respContent = reader.ReadToEnd();
                        string exMsg = string.Format(">>>> 网络请求地址: {0}", serviceUrl);
                        Logger.Error(exMsg);
                        exMsg = string.Format(">>>> 网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}", respStatusCode, respStatusCodeMsg, webEx.StackTrace);
                        Logger.Error(exMsg);

                        httpRespResult = new HttpRespResult();
                        httpRespResult.IsNetworkSuccess = true;
                        httpRespResult.NetworkMsg = "网络请求成功";
                        httpRespResult.HttpStatusCode = respStatusCode;
                        httpRespResult.HttpStatusCodeMsg = respStatusCodeMsg;
                        httpRespResult.RespData = respContent;
                        return httpRespResult;
                    }
                    else
                    {
                        string exStatus = webEx.Status.ToString();
                        string exMessage = webEx.Message;
                        string exMsg = string.Format(">>>> 网络请求地址: {0}", serviceUrl);
                        Logger.Error(exMsg);
                        exMsg = string.Format(">>>> null网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}", exStatus, exMessage, webEx.StackTrace);
                        Logger.Error(exMsg);

                        httpRespResult = new HttpRespResult();
                        httpRespResult.IsNetworkSuccess = false;
                        httpRespResult.NetworkMsg = exMessage;
                        return httpRespResult;
                        throw webEx;
                    }
                }
                else
                {
                    string exStatus = webEx.Status.ToString();
                    string exMessage = webEx.Message;
                    string exMsg = string.Format(">>>> 网络请求地址: {0}", serviceUrl);
                    Logger.Error(exMsg);
                    exMsg = string.Format(">>>> 网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}",exStatus, exMessage, webEx.StackTrace);
                    Logger.Error(exMsg);

                    httpRespResult = new HttpRespResult();
                    httpRespResult.IsNetworkSuccess = false;
                    httpRespResult.NetworkMsg = exMessage;
                    return httpRespResult;
                }
            }
            catch (Exception ex)
            {
                string exMessage = ex.Message;
                string exMsg = string.Format(">>>> 网络请求地址: {0}", serviceUrl);
                Logger.Error(exMsg);
                exMsg = string.Format(">>>> 网络请求出现Exception异常: {0}  StackTrace: {1}",exMessage, ex.StackTrace);
                Logger.Error(exMsg);

                httpRespResult = new HttpRespResult();
                httpRespResult.IsNetworkSuccess = false;
                httpRespResult.NetworkMsg = exMessage;
                return httpRespResult;
            }
            finally
            {
                if (null != reader)
                {
                    reader.Close();
                }
                if (null != webResp)
                {
                    webResp.Close();
                }
                if (null != webReq)
                {
                    webReq.Abort();
                }
            }
            return httpRespResult;
        }
        #endregion

        #region POST 请求
        public HttpRespResult Post(string serviceUrl, string data, Dictionary<string, string> postHeaders, string contentType)
        {
            return executeHttpRequest(serviceUrl, data, "POST", postHeaders, contentType);
        }
        #endregion

        //通用请求
        public HttpRespResult SendHttp(string serviceUrl, string httpType,string data, Dictionary<string, string> postHeaders, string contentType)
        {
            return executeHttpRequest(serviceUrl, data, httpType, postHeaders, contentType);
        }

        #region PUT 请求
        public HttpRespResult Put(string serviceUrl, string data, Dictionary<string, string> postHeaders, string contentType)
        {
            return executeHttpRequest(serviceUrl, data, "PUT", postHeaders,contentType);
        }
        #endregion

        #region DELETE 请求
        public HttpRespResult Delete(string serviceUrl, string data, Dictionary<string, string> postHeaders,string contentType)
        {
            return executeHttpRequest(serviceUrl, data, "DELETE", postHeaders, contentType);
        }
        #endregion

        #region 执行网络请求
        private HttpRespResult executeHttpRequest(string url, string data, string type, Dictionary<string, string> postHeaders,string contentType)
        {
            HttpWebRequest webReq = null;
            HttpWebResponse webResp = null;
            StreamReader reader = null;
            // HTTP响应状态码
            int respStatusCode = 0;
            // HTTP响应状态的描述性信息
            string respStatusCodeMsg = null;
            // 响应信息
            string respContent = string.Empty;
            // HTTP响应结果
            HttpRespResult httpRespResult = null;
            try
            {
                //构造一个Web请求的对象
                webReq = (HttpWebRequest)WebRequest.Create(url);
                Encoding encoding = System.Text.Encoding.GetEncoding("UTF-8");
                // 把请求数据转成“UTF-8”的字节流
                byte[] bodyBytes = Encoding.UTF8.GetBytes(data);
                webReq.Method = type;
                webReq.ContentLength = bodyBytes.Length;

                if (null != postHeaders)
                {
                    //遍历字典
                    foreach (KeyValuePair<string, string> header in postHeaders)
                    {
                        webReq.Headers.Add(header.Key, header.Value);
                    }
                }
                webReq.Accept = contentType;
                webReq.ContentType = contentType;
                // 请求将跟随的重定向响应的最大数目。 默认值为 50
                webReq.MaximumAutomaticRedirections = 50;
                webReq.AllowAutoRedirect = true;

                // 发送请求
                Stream stream = webReq.GetRequestStream();
                stream.Write(bodyBytes, 0, bodyBytes.Length);
                stream.Close();

                //获取Web请求的响应内容
                webResp = (HttpWebResponse)webReq.GetResponse();
                // 获取 HTTP响应状态码
                respStatusCode = Convert.ToInt32(webResp.StatusCode);
                // 获取 HTTP响应状态的描述性信息
                respStatusCodeMsg = webResp.StatusCode.ToString();

                // 通过响应流构造一个StreamReader
                reader = new StreamReader(webResp.GetResponseStream(), Encoding.UTF8);
                // 利用 StreamReader 从头到尾读取响应内容
                respContent = reader.ReadToEnd();

                httpRespResult = new HttpRespResult();
                httpRespResult.IsNetworkSuccess = true;
                httpRespResult.NetworkMsg = "网络请求成功";
                httpRespResult.HttpStatusCode = respStatusCode;
                httpRespResult.HttpStatusCodeMsg = respStatusCodeMsg;
                httpRespResult.RespData = respContent;

            }
            catch (WebException webEx)
            {
                if (webEx.Status == WebExceptionStatus.ProtocolError)
                {
                    webResp = (HttpWebResponse)webEx.Response;
                    if (null != webResp)
                    {
                        // 获取 HTTP响应状态码
                        respStatusCode = Convert.ToInt32(webResp.StatusCode);
                        // 获取 HTTP响应状态的描述性信息
                        respStatusCodeMsg = webResp.StatusCode.ToString();

                        reader = new StreamReader(webResp.GetResponseStream(), Encoding.UTF8);
                        respContent = reader.ReadToEnd();
                        string exMsg = string.Format(">>>> 网络请求地址: {0}", url);
                        Logger.Error(exMsg);
                        exMsg = string.Format(">>>> 网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}", respStatusCode, respStatusCodeMsg, webEx.StackTrace);
                        Logger.Error(exMsg);

                        httpRespResult = new HttpRespResult();
                        httpRespResult.IsNetworkSuccess = true;
                        httpRespResult.NetworkMsg = "网络请求成功";
                        httpRespResult.HttpStatusCode = respStatusCode;
                        httpRespResult.HttpStatusCodeMsg = respStatusCodeMsg;
                        httpRespResult.RespData = respContent;
                        return httpRespResult;
                    }
                    else
                    {
                        string exStatus = webEx.Status.ToString();
                        string exMessage = webEx.Message;
                        string exMsg = string.Format(">>>> 网络请求地址: {0}", url);
                        Logger.Error(exMsg);
                        exMsg = string.Format(">>>> 网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}", exStatus, exMessage, webEx.StackTrace);
                        Logger.Error(exMsg);

                        httpRespResult = new HttpRespResult();
                        httpRespResult.IsNetworkSuccess = false;
                        httpRespResult.NetworkMsg = exMessage;
                        return httpRespResult;
                        throw webEx;
                    }
                }
                else
                {
                    string exStatus = webEx.Status.ToString();
                    string exMessage = webEx.Message;
                    string exMsg = string.Format(">>>> 网络请求地址: {0}", url);
                    Logger.Error(exMsg);
                    exMsg = string.Format(">>>> 网络请求出现 WebException 异常: {0} - {1}  StackTrace: {2}", exStatus, exMessage, webEx.StackTrace);
                    Logger.Error(exMsg);

                    httpRespResult = new HttpRespResult();
                    httpRespResult.IsNetworkSuccess = false;
                    httpRespResult.NetworkMsg = exMessage;
                    return httpRespResult;
                }
            }
            catch (Exception ex)
            {
                string exMessage = ex.Message;
                string exMsg = string.Format(">>>> 网络请求地址: {0}", url);
                Logger.Error(exMsg);
                exMsg = string.Format(">>>> 网络请求出现Exception异常: {0}  StackTrace: {1}", exMessage, ex.StackTrace);
                Logger.Error(exMsg);

                httpRespResult = new HttpRespResult();
                httpRespResult.IsNetworkSuccess = false;
                httpRespResult.NetworkMsg = exMessage;
                return httpRespResult;
            }
            finally
            {
                if (null != reader)
                {
                    reader.Close();
                }
                if (null != webResp)
                {
                    webResp.Close();
                }
                if (null != webReq)
                {
                    webReq.Abort();
                }
            }
            return httpRespResult;
        }
        #endregion

        /// <summary>
        /// 模拟PUT请求上传文件
        /// </summary>
        /// <param name="url"></param>
        /// <param name="param"></param>
        /// <returns></returns>
        public int SendPUT(string url, string filePath, Dictionary<string, string> putHeaders, string contentType)
        {
            int result = 0;
            int http_StatusCode = 0;
            string http_ResponseMessage = null;
            try
            {
                //注意提交的编码 这边是需要改变的 这边默认的是Default：系统当前编码
                byte[] fileData = File2Bytes(filePath);

                // 设置提交的相关参数 
                HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
                Encoding myEncoding = Encoding.UTF8;
                request.Method = "PUT";
                request.KeepAlive = false;
                request.AllowAutoRedirect = false;
                //遍历字典
                if (null != putHeaders)
                {
                    // 设置请求头
                    foreach (KeyValuePair<string, string> kvp in putHeaders)
                    {
                        request.Headers.Add(kvp.Key, kvp.Value);
                    }
                }
                request.ContentType = contentType;

                // 提交请求数据 
                System.IO.Stream outputStream = request.GetRequestStream();
                outputStream.Write(fileData, 0, fileData.Length);
                outputStream.Close();

                HttpWebResponse response;
                Stream responseStream;
                StreamReader reader;
                string srcString;
                response = request.GetResponse() as HttpWebResponse;
                // Statuscode 为枚举类型，200为正常，其他输出异常，需要转为int型才会输出状态码
                http_StatusCode = Convert.ToInt32(response.StatusCode);
                http_ResponseMessage = response.StatusCode.ToString();
                if (200 == http_StatusCode)
                {
                    responseStream = response.GetResponseStream();
                    reader = new System.IO.StreamReader(responseStream, Encoding.GetEncoding("UTF-8"));
                    srcString = reader.ReadToEnd();
                    //result = srcString;   //返回值赋值
                    reader.Close();
                    result = http_StatusCode;
                }
                else
                {
                    MessageBox.Show("系统提示", "HTTP响应码： " + http_StatusCode + ", HTTP响应信息： " + http_ResponseMessage);
                }
            }
            catch (WebException ex)
            {
                MessageBox.Show("网络请求时发生异常：", ex.Message);
            }
            return result;
        }

        private static byte[] File2Bytes(string filePath)
        {
            if (!System.IO.File.Exists(filePath))
            {
                return new byte[0];
            }

            FileInfo fi = new FileInfo(filePath);
            byte[] buff = new byte[fi.Length];

            FileStream fs = fi.OpenRead();
            fs.Read(buff, 0, Convert.ToInt32(fs.Length));
            fs.Close();

            return buff;
        }

        /// <summary>
        /// 获取PUT头信息
        /// </summary>
        /// <param name="contentBase64Md5"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public Dictionary<string, string> getPUTHeaders(string contentBase64Md5, string encoding)
        {
            Dictionary<string, string> putHeaders = new Dictionary<string, string>();
            putHeaders.Add("Content-MD5", contentBase64Md5);
            putHeaders.Add("Charset", encoding);
            return putHeaders;
        }

        /// <summary>
        /// 构造POST头信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="signature"></param>
        /// <param name="algorithm"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public Dictionary<string, string> builderPOSTHeaders(string projectId, string signature,string timeStamp,string contentMD5, string algorithm, string encoding)
        {
            Dictionary<string, string> postHeaders = new Dictionary<string, string>();
            postHeaders.Add("X-Tsign-Open-App-Id", projectId);
            postHeaders.Add("X-Tsign-Open-Auth-Mode", "Signature");
            postHeaders.Add("Charset", "UTF-8");
            postHeaders.Add("X-Tsign-Open-Ca-Timestamp", timeStamp);
            postHeaders.Add("X-Tsign-Open-Ca-Signature", signature);
            postHeaders.Add("Content-MD5", contentMD5);

            return postHeaders;
        }


        private static byte[] GetMultipartFormData(Dictionary<string, object> postParameters, string boundary)
        {
            Stream formDataStream = new System.IO.MemoryStream();
            bool needsCLRF = false;

            foreach (var param in postParameters)
            {
                // Thanks to feedback from commenters, add a CRLF to allow multiple parameters to be added.
                // Skip it on the first parameter, add it to subsequent parameters.
                if (needsCLRF)
                    formDataStream.Write(Encoding.UTF8.GetBytes("\r\n"), 0, Encoding.UTF8.GetByteCount("\r\n"));

                needsCLRF = true;

                if (param.Value is FileParameter)
                {
                    FileParameter fileToUpload = (FileParameter)param.Value;

                    // Add just the first part of this param, since we will write the file data directly to the Stream
                    string header = string.Format("--{0}\r\nContent-Disposition: form-data; name=\"{1}\"; filename=\"{2}\"\r\nContent-Type: {3}\r\n\r\n",
                        boundary,
                        param.Key,
                        fileToUpload.FileName ?? param.Key,
                        fileToUpload.ContentType ?? "application/octet-stream");

                    formDataStream.Write(Encoding.UTF8.GetBytes(header), 0, Encoding.UTF8.GetByteCount(header));

                    // Write the file data directly to the Stream, rather than serializing it to a string.
                    formDataStream.Write(fileToUpload.File, 0, fileToUpload.File.Length);
                }
                else
                {
                    string postData = string.Format("--{0}\r\nContent-Disposition: form-data; name=\"{1}\"\r\n\r\n{2}",
                        boundary,
                        param.Key,
                        param.Value);
                    formDataStream.Write(Encoding.UTF8.GetBytes(postData), 0, Encoding.UTF8.GetByteCount(postData));
                }
            }

            // Add the end of the request.  Start with a newline
            string footer = "\r\n--" + boundary + "--\r\n";
            formDataStream.Write(Encoding.UTF8.GetBytes(footer), 0, Encoding.UTF8.GetByteCount(footer));

            // Dump the Stream into a byte[]
            formDataStream.Position = 0;
            byte[] formData = new byte[formDataStream.Length];
            formDataStream.Read(formData, 0, formData.Length);
            formDataStream.Close();

            return formData;
        }

        public class FileParameter
        {
            public byte[] File { get; set; }
            public string FileName { get; set; }
            public string ContentType { get; set; }
            public FileParameter(byte[] file) : this(file, null) { }
            public FileParameter(byte[] file, string filename) : this(file, filename, null) { }
            public FileParameter(byte[] file, string filename, string contenttype)
            {
                File = file;
                FileName = filename;
                ContentType = contenttype;
            }
        }
    }
}