﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

/********************************************************************************

** 描述: 日志记录辅助类，仅供接口调试参考
** 日期: 2020/11/26

*********************************************************************************/

namespace WinTechWrapperDemo.demoUtils
{
    public class LogHelper
    {
        /// <summary>
        /// 异常日志信息格式化，自定义描述信息
        /// </summary>
        /// <param name="message"></param>
        /// <param name="ex"></param>
        /// <returns></returns>
        public static string FormatLogExMsg(string message, Exception ex)
        {
            // 操作系统默认换行符
            string enter = System.Environment.NewLine;
            StringBuilder msg = new StringBuilder();
            msg.AppendFormat("***************************************{0}",enter);
            msg.AppendFormat("异常发生时间: {0} {1}", DateTime.Now, enter);
            msg.AppendFormat("导致当前异常的 Exception 实例: {0} {1}", ex.InnerException, enter);
            msg.AppendFormat("导致异常的应用程序或对象的名称: {0} {1}", ex.Source, enter);
            msg.AppendFormat("引发异常的方法: {0} {1}", ex.TargetSite, enter);
            msg.AppendFormat("异常消息: {0} {1}", message, enter);
            msg.AppendFormat("异常堆栈信息: {0} {1}", ex.StackTrace, enter);
            msg.Append("***************************************");
            return msg.ToString();
        }

        /// <summary>
        /// 异常日志信息格式化
        /// </summary>
        /// <param name="message"></param>
        /// <param name="ex"></param>
        /// <returns></returns>
        public static string FormatLogExMsg(Exception ex)
        {
            // 操作系统默认换行符
            string enter = System.Environment.NewLine;
            StringBuilder msg = new StringBuilder();
            msg.AppendFormat("***************************************{0}", enter);
            msg.AppendFormat("异常发生时间: {0} {1}", DateTime.Now, enter);
            msg.AppendFormat("导致当前异常的 Exception 实例: {0} {1}", ex.InnerException, enter);
            msg.AppendFormat("导致异常的应用程序或对象的名称: {0} {1}", ex.Source, enter);
            msg.AppendFormat("引发异常的方法: {0} {1}", ex.TargetSite, enter);
            msg.AppendFormat("异常消息: {0} {1}", ex.Message, enter);
            msg.AppendFormat("异常堆栈信息: {0} {1}", ex.StackTrace, enter);
            msg.Append("***************************************");
            return msg.ToString();
        }
        /// <summary>
        /// 日志信息格式化
        /// </summary>
        /// <param name="message"></param>
        /// <returns></returns>
        public static string FormatLogMsg(string message)
        {
            // 操作系统默认换行符
            string enter = System.Environment.NewLine;
            StringBuilder msg = new StringBuilder();
            msg.AppendFormat("***************************************{0}", enter);
            msg.AppendFormat("日志记录时间: {0} {1}", DateTime.Now, enter);
            msg.AppendFormat("日志记录信息: {0} {1}", message, enter);
            msg.Append("***************************************");
            return msg.ToString();
        }
    }
}
