﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace WindowsFormsApp1
{
    public partial class FrmMain : Form
    {

        private void button1_Click(object sender, EventArgs e)
        {
            //获取鉴权Token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            //发送Http GET请求
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";
            textBox2.Text = apiUrl;
            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                textBox3.Text = token;
            }
            else {
                textBox3.Text = "token获取失败";
            }

        }

        private void button3_Click(object sender, EventArgs e)
        {
            //创建个人账户

            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接创建个人账户JSON字符串，当作请求body体
                JObject dataJson = new JObject();
                dataJson.Add("thirdPartyUserId", "20191217155830111");
                dataJson.Add("name", Config.ParameterConfig.name);
                dataJson.Add("idType", Config.ParameterConfig.idType);
                dataJson.Add("idNumber", Config.ParameterConfig.idNumber);
                dataJson.Add("mobile", Config.ParameterConfig.mobile);
                dataJson.Add("email", Config.ParameterConfig.email);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.get_account;
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //创建个人模板印章
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接创建个人模板印章JSON字符串，当作请求body体
                JObject dataJson = new JObject();
                dataJson.Add("alias", "印章别名");
                dataJson.Add("color", "RED");
                dataJson.Add("height", 500);
                dataJson.Add("width", 500);
                dataJson.Add("type", "SQUARE");
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.get_personaltemplate(Config.ParameterConfig.accountId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }

        }

        private void button5_Click(object sender, EventArgs e)
        {
            //上传方式创建文件
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接上传方式创建文件JSON字符串，当作请求body体

                String contentMd5 = Core.GetFileInfo.GetContentMD5FromFile(Config.ParameterConfig.filepath);
                int fileSize = Core.GetFileInfo.GetFileLength(Config.ParameterConfig.filepath);
                JObject dataJson = new JObject();
                dataJson.Add("contentMd5", contentMd5);
                dataJson.Add("contentType", Config.ParameterConfig.fileMime);
                dataJson.Add("fileName", Config.ParameterConfig.fileName);
                dataJson.Add("fileSize", fileSize);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.get_UploadUrl;
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);

                //解析返回参数，提取上传地址
                if (!string.IsNullOrEmpty(result))
                {
                    JObject obj = (JObject)JsonConvert.DeserializeObject(result);
                    if ("0".Equals(obj["code"].ToString()))
                    {
                        string data = null;
                        data = obj["data"].ToString();
                        JObject dataObj = (JObject)JsonConvert.DeserializeObject(data);
                        string uploadUrl = dataObj["uploadUrl"].ToString();
                        string fileId = dataObj["fileId"].ToString();
                        //文件流上传文件
                        //发送put请求
                        int fileresult = Http.SendHttp.SendPUT(uploadUrl, Config.ParameterConfig.filepath, Http.SendHttp.getPUTHeaders(contentMd5, "UTF-8"), Config.ParameterConfig.fileMime);

                        if (200 == fileresult)
                            textBox3.Text = "文件流上传成功，fileId为" + fileId;
                        else
                            textBox3.Text = "文件流上传失败";
                    }
                    else
                    {
                        string code = obj["code"].ToString();
                        string msg = obj["message"].ToString();
                        MessageBox.Show("错误码Code = " + code + ", 错误信息msg = " + msg);
                        textBox3.Text = "文件流上传失败，" + result;
                    }
                }
            }
        }

        
        private void button6_Click(object sender, EventArgs e)
        {
            //创建签署流程
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接创建签署流程JSON字符串，当作请求body体
                JObject dataJson = new JObject();
                dataJson.Add("autoArchive", true);
                dataJson.Add("businessScene", "文件主题");

                JObject configInfo = new JObject();
                configInfo.Add("noticeDeveloperUrl", Config.ParameterConfig.noticeDeveloperUrl);
                configInfo.Add("noticeType", "1");
                configInfo.Add("redirectUrl", Config.ParameterConfig.redirectUrl);
                configInfo.Add("signPlatform", "1,2");

                dataJson.Add("configInfo", configInfo);
                dataJson.Add("initiatorAccountId", Config.ParameterConfig.accountId);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.get_signflows;
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }

        }

        private void button7_Click(object sender, EventArgs e)
        {
            //流程文档添加
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接流程文档添加JSON字符串，当作请求body体
                JObject dataJson = new JObject();

                JObject documentBean = new JObject();
                documentBean.Add("fileId", Config.ParameterConfig.fileId);
                documentBean.Add("fileName", "文档名称");

                //string jsStr = Newtonsoft.Json.JsonConvert.SerializeObject(documentBean);
                JArray ja = new JArray();
                ja.Add(documentBean);

                dataJson.Add("docs", ja);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.add_documents(Config.ParameterConfig.flowId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            //添加平台自动签署区
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接流程文档添加JSON字符串，当作请求body体
                JObject dataJson = new JObject();

                JObject signfields = new JObject();
                signfields.Add("fileId", Config.ParameterConfig.fileId);
                signfields.Add("order", 1);

                JObject posBean = new JObject();
                posBean.Add("posPage", "1");
                posBean.Add("posX", 500);
                posBean.Add("posY", 500);
                posBean.Add("addSignTime", true);
               
                signfields.Add("posBean", posBean);
                signfields.Add("signType", 1);
                signfields.Add("thirdOrderNo", "20191219151130111");

                JArray ja = new JArray();
                ja.Add(signfields);

                dataJson.Add("signfields", ja);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.add_platformSign(Config.ParameterConfig.flowId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            //添加手动盖章签署区
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                //拼接流程文档添加JSON字符串，当作请求body体


                JObject dataJson = new JObject();

                JObject signfields = new JObject();
                signfields.Add("fileId", Config.ParameterConfig.fileId);
                signfields.Add("signerAccountId", Config.ParameterConfig.accountId);
                signfields.Add("assignedPosbean",true);
                signfields.Add("order", 1);

                JObject posBean = new JObject();
                posBean.Add("posPage", "1");
                posBean.Add("posX", 400);
                posBean.Add("posY", 400);
                posBean.Add("addSignTime", true);

                signfields.Add("posBean", posBean);
                signfields.Add("sealType", "1,0");
                signfields.Add("signType", 1);
                signfields.Add("thirdOrderNo", "20191219151130222");

                JArray ja = new JArray();
                ja.Add(signfields);

                dataJson.Add("signfields", ja);
                textBox2.Text = dataJson.ToString();

                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.add_handSign(Config.ParameterConfig.flowId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Post(apiUrlgetAccont, headers, dataJson.ToString(), contentType);
                textBox3.Text = result;
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            //开启签署流程
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                
                textBox2.Text = Config.APIConfig.start_signflow(Config.ParameterConfig.flowId);
                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.start_signflow(Config.ParameterConfig.flowId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Put(apiUrlgetAccont, headers, null, contentType);
                textBox3.Text = result;
            }
            }

        private void button11_Click(object sender, EventArgs e)
        {
            //获取签署地址
            //获取token
            //token有效时长为120分钟。如果有多台机器建议使用分布式存储，新旧token会共存5分钟。请把token做全局唯一
            string apiUrl = Config.APIConfig.access_token + "?appId=" + Config.Config.AppId + "&secret=" + Config.Config.App_Secret + "&grantType=client_credentials";

            String token = Method.GetToken.token(apiUrl);
            if (!string.IsNullOrEmpty(token))
            {
                textBox2.Text = Config.APIConfig.get_executeUrl(Config.ParameterConfig.flowId, Config.ParameterConfig.accountId);
       
                // 获取API调用地址
                string apiUrlgetAccont = Config.APIConfig.get_executeUrl(Config.ParameterConfig.flowId, Config.ParameterConfig.accountId);
                // 构建请求头
                Dictionary<string, string> headers = Http.SendHttp.buildHeaders(Config.Config.AppId, token);
                // HTTP请求内容类型
                string contentType = "application/json";
                string result = Http.SendHttp.Get(apiUrlgetAccont, headers,  contentType);
                textBox3.Text = result;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        public FrmMain()
        {
            InitializeComponent();
        }
    }
}
