﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApp1.Http
{
    class SendHttp
    {

        #region GET方式实现
        public static string Get(string url, Dictionary<string, string> headers, string contentType)
        {
            HttpWebRequest webRequest = null;
            HttpWebResponse webResponse = null;
            Stream resStream = null;
            StreamReader resStreamReader = null;
            // 响应信息
            string respContent = string.Empty;
            try
            {
                //构造一个Web请求的对象
                webRequest = (HttpWebRequest)WebRequest.Create(url);

                if (null != headers)
                {
                    // 设置请求头
                    foreach (KeyValuePair<string, string> kvp in headers)
                    {
                        webRequest.Headers.Add(kvp.Key, kvp.Value);
                    }
                }
                webRequest.ContentType = contentType;
                // 请求将跟随的重定向响应的最大数目。 默认值为 50
                webRequest.MaximumAutomaticRedirections = 50;
                webRequest.AllowAutoRedirect = true;

                //获取Web请求的响应内容
                webResponse = (HttpWebResponse)webRequest.GetResponse();
                resStream = webResponse.GetResponseStream();
                //通过响应流构造一个StreamReader
                resStreamReader = new StreamReader(resStream, Encoding.UTF8);
                respContent = resStreamReader.ReadToEnd();
            }
            catch (WebException ex)
            {
                webResponse = (HttpWebResponse)ex.Response;
                int httpCode = (int)webResponse.StatusCode;
                
                resStream = webResponse.GetResponseStream();
                resStreamReader = new StreamReader(resStream, Encoding.UTF8);
                respContent = resStreamReader.ReadToEnd();
            }
            finally
            {
                if (null != resStreamReader)
                {
                    resStreamReader.Close();
                }
                if (null != resStream)
                {
                    resStream.Close();
                }
                if (null != webResponse)
                {
                    webResponse.Close();
                }
                if (null != webRequest)
                {
                    webRequest.Abort();
                }
            }
            return respContent;
        }
        #endregion

        #region POST方式实现
        public static string Post(string url, Dictionary<string, string> headers, string data, string contentType)
        {
            return executeHttpRequest(url, headers, data, "POST", contentType);
        }
        #endregion

        #region Put方式实现
        public static string Put(string url, Dictionary<string, string> headers, string data, string contentType)
        {
            return executeHttpRequest(url, headers, data, "PUT", contentType);
        }
        #endregion


        #region 执行Http请求
        private static string executeHttpRequest(string url, Dictionary<string, string> headers, string data, string reqMethod, string contentType)
        {
            string reqInfo = string.Format(">>>请求Url:{0},请求Body:{1}", url, data);
            HttpWebRequest webRequest = null;
            HttpWebResponse webResponse = null;
            Stream reqStream = null;
            Stream resStream = null;
            StreamReader resStreamReader = null;
            // 响应信息
            string respContent = string.Empty;
            try
            {
                //构造一个Web请求的对象
                webRequest = (HttpWebRequest)WebRequest.Create(url);
                Encoding encoding = System.Text.Encoding.GetEncoding("UTF-8");

                if (null != headers)
                {
                    // 设置请求头
                    foreach (KeyValuePair<string, string> kvp in headers)
                    {
                        webRequest.Headers.Add(kvp.Key, kvp.Value);
                    }
                }

                webRequest.Headers.Add("Platform", "10");
                //转成网络流
                if (null != data) {
                    byte[] bodyBytes = encoding.GetBytes(data);
                    webRequest.Method = reqMethod;
                    webRequest.ContentLength = bodyBytes.Length;
                    webRequest.ContentType = contentType;
                    // 请求将跟随的重定向响应的最大数目。 默认值为 50
                    webRequest.MaximumAutomaticRedirections = 50;
                    webRequest.AllowAutoRedirect = true;

                    // 发送请求
                    reqStream = webRequest.GetRequestStream();
                    reqStream.Write(bodyBytes, 0, bodyBytes.Length);
                  
                }
                else {
                    webRequest.Method = reqMethod;
                    webRequest.ContentType = contentType;
                    // 请求将跟随的重定向响应的最大数目。 默认值为 50
                    webRequest.MaximumAutomaticRedirections = 50;
                    webRequest.AllowAutoRedirect = true;
                    reqStream = webRequest.GetRequestStream();
                }

                reqStream.Close();
               

                //获取Web请求的响应内容
                webResponse = (HttpWebResponse)webRequest.GetResponse();
                int httpStatus = (int)webResponse.StatusCode;
               
                string statusDescription = webResponse.StatusDescription;

                resStream = webResponse.GetResponseStream();
                //通过响应流构造一个StreamReader
                resStreamReader = new StreamReader(resStream, Encoding.UTF8);
                respContent = resStreamReader.ReadToEnd();
            }
            catch (WebException ex)
            {
                webResponse = (HttpWebResponse)ex.Response;
                int httpStatus = (int)webResponse.StatusCode;
                string statusDescription = webResponse.StatusDescription;

                resStream = webResponse.GetResponseStream();
                resStreamReader = new StreamReader(resStream, Encoding.UTF8);
                respContent = resStreamReader.ReadToEnd();
            }
            finally
            {
                if (null != reqStream)
                {
                    reqStream.Close();
                }
                if (null != resStreamReader)
                {
                    resStreamReader.Close();
                }
                if (null != resStream)
                {
                    resStream.Close();
                }
                if (null != webResponse)
                {
                    webResponse.Close();
                }
                if (null != webRequest)
                {
                    webRequest.Abort();
                }
            }
            return respContent;
        }
        #endregion

        /// <summary>
        /// 模拟PUT请求上传文件
        /// </summary>
        /// <param name="url"></param>
        /// <param name="param"></param>
        /// <returns></returns>
        public static int SendPUT(string url, string filePath, Dictionary<string, string> putHeaders, string contentType)
        {
            int result = 0;
            int http_StatusCode = 0;
            string http_ResponseMessage = null;
            try
            {
                //注意提交的编码 这边是需要改变的 这边默认的是Default：系统当前编码
                byte[] fileData = File2Bytes(filePath);

                // 设置提交的相关参数 
                HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
                Encoding myEncoding = Encoding.UTF8;
                request.Method = "PUT";
                request.KeepAlive = false;
                request.AllowAutoRedirect = false;
                //遍历字典
                if (null != putHeaders)
                {
                    // 设置请求头
                    foreach (KeyValuePair<string, string> kvp in putHeaders)
                    {
                        request.Headers.Add(kvp.Key, kvp.Value);
                    }
                }
                request.ContentType = contentType;

                // 提交请求数据 
                System.IO.Stream outputStream = request.GetRequestStream();
                outputStream.Write(fileData, 0, fileData.Length);
                outputStream.Close();

                HttpWebResponse response;
                Stream responseStream;
                StreamReader reader;
                string srcString;
                response = request.GetResponse() as HttpWebResponse;
                // Statuscode 为枚举类型，200为正常，其他输出异常，需要转为int型才会输出状态码
                http_StatusCode = Convert.ToInt32(response.StatusCode);
                http_ResponseMessage = response.StatusCode.ToString();
                if (200 == http_StatusCode)
                {
                    responseStream = response.GetResponseStream();
                    reader = new System.IO.StreamReader(responseStream, Encoding.GetEncoding("UTF-8"));
                    srcString = reader.ReadToEnd();
                    //result = srcString;   //返回值赋值
                    reader.Close();
                    result = http_StatusCode;
                }
                else
                {
                    MessageBox.Show("系统提示", "HTTP响应码： " + http_StatusCode + ", HTTP响应信息： " + http_ResponseMessage);
                }
            }
            catch (WebException ex)
            {
                MessageBox.Show("网络请求时发生异常：", ex.Message);
            }
            return result;
        }

        private static byte[] File2Bytes(string filePath)
        { 
        if (!System.IO.File.Exists(filePath))
        {
            return new byte[0];
        }

        FileInfo fi = new FileInfo(filePath);
        byte[] buff = new byte[fi.Length];

        FileStream fs = fi.OpenRead();
        fs.Read(buff, 0, Convert.ToInt32(fs.Length));
        fs.Close();

        return buff;
        }

        /// <summary>
        /// 获取PUT头信息
        /// </summary>
        /// <param name="contentBase64Md5"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public static Dictionary<string, string> getPUTHeaders(string contentBase64Md5, string encoding)
        {
            Dictionary<string, string> putHeaders = new Dictionary<string, string>();
            putHeaders.Add("Content-MD5", contentBase64Md5);
            putHeaders.Add("Charset", encoding);
            return putHeaders;
        }

        #region 获取请求头信息
        /// <summary>
        /// 获取POST头信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="signature"></param>
        /// <param name="algorithm"></param>
        /// <param name="encoding"></param>
        /// <returns></returns>
        public static Dictionary<string, string> buildHeaders(string appId, string token)
        {
            Dictionary<string, string> postHeaders = new Dictionary<string, string>();
            postHeaders.Add("X-Tsign-Open-App-Id", appId);
            postHeaders.Add("X-Tsign-Open-Token", token);
            postHeaders.Add("Charset", "UTF-8");
            return postHeaders;
        }
        #endregion

    }
}
