package Demo

import (
	Beans "WukongAPI-Golang/beans"
	HttpHelper "WukongAPI-Golang/http_utils"
	"log"
	"strconv"
)

func CreateFlowOneStep(dataJsonStr string) []byte  {
	apiUrl :="/api/v2/signflows/createFlowOneStep"
	log.Println("一步发起签署：--------------")
	initResult, httpStatus := HttpHelper.SendCommHttp(apiUrl, dataJsonStr, "POST")
	log.Println("返回参数：------------------")
	log.Println(string(initResult))
	log.Println("状态码：-----------------------")
	log.Println(httpStatus)
	return initResult
}

func GetFileSignUrlInfo(getFileSignUrlInfo Beans.GetFileSignUrlInfo) []byte  {
	apiUrl :="/v1/signflows/"+getFileSignUrlInfo.FlowId+"/executeUrl?accountId="+getFileSignUrlInfo.AccountId
	if getFileSignUrlInfo.OrganizeId!=""{
		apiUrl=apiUrl+"&organizeId="+getFileSignUrlInfo.OrganizeId
	}
	UrlType := strconv.Itoa(getFileSignUrlInfo.UrlType)
	if UrlType!=""{
		apiUrl=apiUrl+"&urlType="+UrlType
	}

	if getFileSignUrlInfo.AppScheme!=""{
		apiUrl=apiUrl+"&appScheme="+getFileSignUrlInfo.AppScheme
	}
	log.Println("获取签署地址：--------------")
	initResult, httpStatus := HttpHelper.SendCommHttp(apiUrl, "{}", "GET")
	log.Println("返回参数：------------------")
	log.Println(string(initResult))
	log.Println("状态码：-----------------------")
	log.Println(httpStatus)
	return initResult
	
}