package main

import (
	Beans "WukongAPI-Golang/beans"
	Demo "WukongAPI-Golang/demo"
	HttpHelper "WukongAPI-Golang/http_utils"
	Tools "WukongAPI-Golang/utils"
	"encoding/json"
	"fmt"
)


func main() {
	//配置参数(作为全局执行一次即可)
	Demo.EsignInitService()
	var initResult []byte

	//创建个人账号-start
	var createPersonInfo Beans.CreatePersonByThirdPartyUserIdInfo
	createPersonInfo.Email="123@qq.com"
	createPersonInfo.IdNumber="330**********41912"
	createPersonInfo.ThirdPartyUserId="1231ddve1212qre"
	createPersonInfo.Mobile="186******70"
	createPersonInfo.Name="hty"
	var createPersonInfoJson string
	if data, err := json.Marshal(createPersonInfo); err == nil {
		createPersonInfoJson = string(data)
	}
	initResult= Demo.CreatePersonByThirdPartyUserId(createPersonInfoJson)
	CreatePsnByThirdData := Tools.BytetoJson(initResult)["data"]
	CreatePsnByThirdAccountId := CreatePsnByThirdData.(map[string]interface{})["accountId"]
	fmt.Println(CreatePsnByThirdAccountId)
	//创建个人账号-end

	//创建企业账号-start
	var createOrganizationsInfo Beans.CreateOrganizationsByThirdPartyUserIdInfo
	createOrganizationsInfo.ThirdPartyUserId="123fdacq1122ereqerqrew"
	createOrganizationsInfo.Creator=CreatePsnByThirdAccountId.(string)
	createOrganizationsInfo.Name="***********有限公司"
	createOrganizationsInfo.IdNumber="9**************C50A"
	createOrganizationsInfo.OrgLegalName=""
	createOrganizationsInfo.OrgLegalIdNumber=""
	var createOrganizationsInfoJson string
	if data, err := json.Marshal(createOrganizationsInfo); err == nil {
		createOrganizationsInfoJson = string(data)
	}
	initResult= Demo.CreateOrganizationsByThirdPartyUserId(createOrganizationsInfoJson)
	CreateOrgByThirdData:= Tools.BytetoJson(initResult)["data"]
	CreateOrgByThirdOrgId := CreateOrgByThirdData.(map[string]interface{})["orgId"]
	fmt.Println(CreateOrgByThirdOrgId)
	//创建企业账号-end

	//创建个人印章
	var createPersonalTemplateInfo Beans.CreatePersonalTemplateInfo
	createPersonalTemplateInfo.Alias=""
	createPersonalTemplateInfo.Color="RED"
	createPersonalTemplateInfo.Height=""
	createPersonalTemplateInfo.Type="SQUARE"
	createPersonalTemplateInfo.Width=""
	var createPersonalTemplateInfoJson string
	if data, err := json.Marshal(createPersonalTemplateInfo); err == nil {
		createPersonalTemplateInfoJson = string(data)
	}
	initResult= Demo.CreatePersonalTemplate(createPersonalTemplateInfoJson,CreatePsnByThirdAccountId.(string))
	CreatePsnSealsData:= Tools.BytetoJson(initResult)["data"]
	CreatePsnSealsSealId := CreatePsnSealsData.(map[string]interface{})["sealId"]
	fmt.Println(CreatePsnSealsSealId)
	//创建个人印章-end

	//创建企业印章-start
	var createOfficialTemplateInfo Beans.CreateOfficialTemplateInfo
	createOfficialTemplateInfo.Color="RED"
	createOfficialTemplateInfo.Type="TEMPLATE_ROUND"
	createOfficialTemplateInfo.Central="STAR"
	var createOfficialTemplateInfoJson string
	if data, err := json.Marshal(createOfficialTemplateInfo); err == nil {
		createOfficialTemplateInfoJson = string(data)
	}
	initResult= Demo.CreateOfficialTemplate(createOfficialTemplateInfoJson, CreateOrgByThirdOrgId.(string))
	createOfficialSealsData:= Tools.BytetoJson(initResult)["data"]
	createOfficialSealsSealId := createOfficialSealsData.(map[string]interface{})["sealId"]
	fmt.Println(createOfficialSealsSealId)
	//创建企业印章-end

	//获取文件上传地址-start
	filePath :="D:\\测试模板.pdf"
	contentMd5, size := Tools.CountFileMd5(filePath)
	var getFileUploadUrlInfo Beans.GetFileUploadUrlInfo
	getFileUploadUrlInfo.ContentMd5=contentMd5
	getFileUploadUrlInfo.ContentType="application/octet-stream"
	getFileUploadUrlInfo.Convert2Pdf=false
	getFileUploadUrlInfo.FileName="测试模板.pdf"
	getFileUploadUrlInfo.FileSize=size
	var getFileUploadUrlInfoJson string
	if data, err := json.Marshal(getFileUploadUrlInfo); err == nil {
		getFileUploadUrlInfoJson = string(data)
	}
	initResult= Demo.GetFileUploadUrl(getFileUploadUrlInfoJson)
	getFileUploadUrlData:= Tools.BytetoJson(initResult)["data"]
	getFileUploadUrlDataMap := getFileUploadUrlData.(map[string]interface{})
	fileId := getFileUploadUrlDataMap["fileId"]
	uploadUrl := getFileUploadUrlDataMap["uploadUrl"]
	fmt.Println(fileId)
	fmt.Println(uploadUrl)

	//上传文件-start
	result := HttpHelper.UpLoadFile(uploadUrl.(string), filePath, contentMd5, "application/octet-stream")
	fmt.Println(result)
	//上传文件-end

	//一步发起签署-start
	var createFlowOneStepInfo Beans.CreateFlowOneStepInfo
	var doc Beans.Doc
	doc.FileId=fileId.(string)
	Docs := []Beans.Doc{doc}
	createFlowOneStepInfo.Docs=Docs

	var flowInfo Beans.FlowInfo
	flowInfo.BusinessScene="b2c合同签署测试"
	flowInfo.AutoArchive=true
	flowInfo.AutoInitiate=true

	//个人签署信息配置
	var psnSignfield Beans.Signfield
	psnSignfield.FileId=fileId.(string)
	var psnPosBean Beans.PosBean
	psnPosBean.PosPage="1"
	psnPosBean.PosX=200
	psnPosBean.PosY=400
	psnSignfield.PosBean=psnPosBean
	psnSignfields := []Beans.Signfield{psnSignfield}

	var psnSigner Beans.Signer
	var psnSignerAccount Beans.SignerAccount
	psnSignerAccount.SignerAccountId=CreatePsnByThirdAccountId.(string)
	psnSigner.SignerAccount=psnSignerAccount
	psnSigner.Signfields=psnSignfields
	//企业签署信息配置
	var orgSignfield Beans.Signfield
	orgSignfield.FileId=fileId.(string)
	var orgPosBean Beans.PosBean
	orgPosBean.PosPage="1"
	orgPosBean.PosX=200
	orgPosBean.PosY=400
	orgSignfield.PosBean=orgPosBean
	orgSignfield.ActorIndentityType="2"
	orgSignfields := []Beans.Signfield{orgSignfield}

	var orgSigner Beans.Signer
	var orgSignerAccount Beans.SignerAccount
	orgSignerAccount.SignerAccountId=CreatePsnByThirdAccountId.(string)
	orgSignerAccount.AuthorizedAccountId=CreateOrgByThirdOrgId.(string)
	orgSigner.SignerAccount=orgSignerAccount
	orgSigner.Signfields=orgSignfields

	signers := []Beans.Signer{psnSigner,orgSigner}
	createFlowOneStepInfo.Docs=Docs
	createFlowOneStepInfo.FlowInfo=flowInfo
	createFlowOneStepInfo.Signers=signers

	var createFlowOneStepInfoJson string
	if data, err := json.Marshal(createFlowOneStepInfo); err == nil {
		createFlowOneStepInfoJson = string(data)
	}
	initResult = Demo.CreateFlowOneStep(createFlowOneStepInfoJson)
	CreateFlowOneStepData:= Tools.BytetoJson(initResult)["data"]
	CreateFlowOneStepDataMap := CreateFlowOneStepData.(map[string]interface{})
	flowId := CreateFlowOneStepDataMap["flowId"]
	fmt.Println(flowId)
	//一步发起签署-end
	
	//获取签署地址-start
	getFileSignUrlInfo := Beans.GetFileSignUrlInfo{
		FlowId:     flowId.(string),
		AccountId:  CreatePsnByThirdAccountId.(string),
		OrganizeId: CreateOrgByThirdOrgId.(string),
		UrlType:    0,
		AppScheme:  "123",
	}
	info := Demo.GetFileSignUrlInfo(getFileSignUrlInfo)
	fmt.Println(string(info))
}