//
//  ViewController.m
//  EsignFaceDemo
//
//  Created by 叶鹏飞 on 2020/4/28.
//  Copyright © 2020 叶鹏飞. All rights reserved.
//

#import "ViewController.h"
#import <EsignSDK/EsignSDKIOS.h>
#import "WBProgressHUD.h"
#define KScreenWidth [[UIScreen mainScreen] bounds].size.width
#define KScreenHeight [[UIScreen mainScreen] bounds].size.height

@interface ViewController () {
    UITextView *_textView;
    UIButton *_cancelBtn;
    UIButton *_initializationBtn;
    UIButton *_confirmBtn;
    
    WBProgressHUD *_hudLoading;
}

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setSubViews];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    if (_hudLoading) {
        [self hideLoading];
    }
}

- (void)setSubViews {
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.title = @"EsignSDKDemo";
    [self.view addSubview:self.textView];
    [self.view addSubview:self.cancelBtn];
    [self.view addSubview:self.initializationBtn];
    [self.view addSubview:self.confirmBtn];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    if ([_textView isFirstResponder]) {
        [_textView resignFirstResponder];
    }
}

#pragma mark - action
- (void)cancelBtnTap {
    // 清除数据
    [self.view endEditing:YES];
    _textView.text = @"";
}

- (void)confirmBtnTap {
    [self.view endEditing:YES];
    if ([self valideTextView]) {
        [self.view endEditing:YES];
        NSString *faceCode = _textView.text;
        [self showLoading:@"" toView:self.view];
        [[EsignFaceManager shareEsignFaceManager] startFaceVerify:faceCode success:^(EsignFaceVerifyResult * _Nonnull error) {
            [self hideLoading];
            [self creatAlertControllerAlert:[NSString stringWithFormat:@"刷脸成功"] handle:nil];
        } failure:^(EsignSDKError * _Nonnull error) {
            [self hideLoading];
            [self creatAlertControllerAlert:[NSString stringWithFormat:@"刷脸失败，失败原因: %@",error.desc] handle:nil];
        }];
    }
}

- (void)initializationBtnTap {
    [self.view endEditing:YES];
   // 初始化，以下配置为沙箱环境demo的测试key和license，如果开发者在自己的项目里需要替换自己包名对应的key和license
    EsignSDKConfig *config = [EsignSDKConfig new];
    config.key = @"s_e696aadf3ec6323e0df40687dd22f651";
    config.license = @"s_bmRrcGUdKLctAQmADNSmMOtsb4bknV0a5hvnSrcUIBIF6uxwd68X9ArEvcCMMEKqGCXOpuvNfFtdX/5EO9y8vcR43adEsUS3B8aXsH/DhXd2zqx8NVfRb+48m31VSLPcJM+S7Y440Z3czB4T2dLpL/Pt2cXbQ3tV4SnMPORlSfFWfIamvsKozunAdobXOZBFoJ8BqUKu6/TJYBKP/Aq2nXjTTgel67r9jsggrBiy9W/rErZN1k8hPIv9TfOOCAW2M9dF5KMEtwVpU5obXym5s8Y7Q6WdiHMryKLdErVorKvjz2QFek2oQqb+446HQPqap2IoYOAK52A4yoOTFqCnefAnmSjqxyJWH8PvVpMG8RyE7dskD3IRiUPJg7AU10ODxMpxd31HgklYUgQN67Rv5LrKx6VMvWl56egDqb9XpHQtZIYMoHvCkDwTVq+MjnzyAW0IX8ZbJ6JmTpN7+Iz4FoWAgBdfaAH89L7Vju0GVqeWhBwIKRqiOOEjVjT7e1O1J+GkGLNpacDLZPvOz86pf71wrcayr32a7Xz9TPAkiRrYi99ksaVElPj2pGdO1jLsi8dFhW8dEHGwwgbcC9SyGlxHLbCaZAGZLq+zo3SRMbNSTpShBi/Gd6xtZlrumHYnRmPkJdmJhECOp/OJ4L3G13dAeD+fMUMWDCrqBZ912sSI3Op5IZvzarCkQZ4F5dNZgjdf4c4bzqdnQcgAig+Y0tBAe5oTCp+mlOWEiIm2vgjkCASPEpjOP80k1BW57H0u";
    
    [self showLoading:@"初始化中..." toView:self.view];
    [[EsignFaceManager shareEsignFaceManager] initConfig:config success:^{
        [self hideLoading];
        [self creatAlertControllerAlert:@"初始化成功" handle:nil];
    } failure:^(EsignSDKError * _Nonnull error) {
        [self hideLoading];
        [self creatAlertControllerAlert:[NSString stringWithFormat:@"初始化失败，失败原因: %@",error.desc] handle:nil];
    }];
}

- (BOOL)valideTextView {
    if (_textView.text.length <= 0) {
        [self creatAlertControllerAlert:@"faceCode不能为空" handle:nil];
        return NO;
    }
    return YES;
}

- (void)creatAlertControllerAlert:(NSString *)megStr handle:(void (^)(void))handleBlock {
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"温馨提示" message:megStr preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *action1 = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (handleBlock) {
            handleBlock();
        }
    }];
    [alert addAction:action1];
    [self presentViewController:alert animated:YES completion:nil];
}


#pragma mark - lazyload
- (UITextView *)textView {
    if (!_textView) {
        _textView = [[UITextView alloc] initWithFrame:CGRectMake(50, 100, KScreenWidth - 100, 200)];
        _textView.layer.backgroundColor = [[UIColor clearColor] CGColor];
        _textView.layer.borderColor = [[UIColor lightGrayColor] CGColor];
        _textView.layer.borderWidth = 1.0;
        _textView.layer.cornerRadius = 10.0f;
        _textView.autocapitalizationType = UITextAutocapitalizationTypeNone;
        [_textView.layer setMasksToBounds:YES];
    }
    return _textView;
}

- (UIButton *)cancelBtn {
    if (!_cancelBtn) {
        _cancelBtn = [[UIButton alloc] initWithFrame:CGRectMake(50, self.textView.bounds.size.height + 150, 50, 44)];
        [_cancelBtn setTitle:@"清除" forState:UIControlStateNormal];
        [_cancelBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
        [_cancelBtn addTarget:self action:@selector(cancelBtnTap) forControlEvents:UIControlEventTouchUpInside];
    }
    return _cancelBtn;
}

- (UIButton *)initializationBtn {
    if (!_initializationBtn) {
        _initializationBtn = [[UIButton alloc] initWithFrame:CGRectMake(KScreenWidth - 180, self.textView.bounds.size.height + 150, 60, 44)];
        [_initializationBtn setTitle:@"初始化" forState:UIControlStateNormal];
        [_initializationBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
        [_initializationBtn addTarget:self action:@selector(initializationBtnTap) forControlEvents:UIControlEventTouchUpInside];
    }
    return _initializationBtn;
}

- (UIButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [[UIButton alloc] initWithFrame:CGRectMake(KScreenWidth - 100, self.textView.bounds.size.height + 150, 50, 44)];
        [_confirmBtn setTitle:@"刷脸" forState:UIControlStateNormal];
        [_confirmBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
        [_confirmBtn addTarget:self action:@selector(confirmBtnTap) forControlEvents:UIControlEventTouchUpInside];
    }
    return _confirmBtn;
}

- (void)showLoading:(NSString *)text toView:(UIView *)view {
    _hudLoading = [WBProgressHUD showHUDAddedTo:view animated:YES];
    _hudLoading.mode = WBProgressHUDModeIndeterminate;
    _hudLoading.labelText = text;
    _hudLoading.labelColor = [UIColor whiteColor];
}

- (void)hideLoading {
    _hudLoading.progress = 1.00f;
    [_hudLoading hide:YES];
}


@end
