/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.options.PropertyOptions;
import com.itextpdf.kernel.xmp.properties.XMPProperty;

class XmpMetaInfoConverter {
    private XmpMetaInfoConverter() {
    }

    static void appendMetadataToInfo(byte[] xmpMetadata, PdfDocumentInfo info) {
        if (xmpMetadata != null) {
            try {
                XMPProperty trapped;
                XMPProperty producer;
                XMPProperty creator;
                XMPProperty keywords;
                String author;
                XMPMeta meta = XMPMetaFactory.parseFromBuffer(xmpMetadata);
                XMPProperty title = meta.getLocalizedText("http://purl.org/dc/elements/1.1/", "title", "x-default", "x-default");
                if (title != null) {
                    info.setTitle(title.getValue());
                }
                if ((author = XmpMetaInfoConverter.fetchArrayIntoString(meta, "http://purl.org/dc/elements/1.1/", "creator")) != null) {
                    info.setAuthor(author);
                }
                if ((keywords = meta.getProperty("http://ns.adobe.com/pdf/1.3/", "Keywords")) != null) {
                    info.setKeywords(keywords.getValue());
                } else {
                    String keywordsStr = XmpMetaInfoConverter.fetchArrayIntoString(meta, "http://purl.org/dc/elements/1.1/", "subject");
                    if (keywordsStr != null) {
                        info.setKeywords(keywordsStr);
                    }
                }
                XMPProperty subject = meta.getLocalizedText("http://purl.org/dc/elements/1.1/", "description", "x-default", "x-default");
                if (subject != null) {
                    info.setSubject(subject.getValue());
                }
                if ((creator = meta.getProperty("http://ns.adobe.com/xap/1.0/", "CreatorTool")) != null) {
                    info.setCreator(creator.getValue());
                }
                if ((producer = meta.getProperty("http://ns.adobe.com/pdf/1.3/", "Producer")) != null) {
                    info.put(PdfName.Producer, new PdfString(producer.getValue(), "UnicodeBig"));
                }
                if ((trapped = meta.getProperty("http://ns.adobe.com/pdf/1.3/", "Trapped")) != null) {
                    info.setTrapped(new PdfName(trapped.getValue()));
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
    }

    static void appendDocumentInfoToMetadata(PdfDocumentInfo info, XMPMeta xmpMeta) throws XMPException {
        PdfDictionary docInfo = info.getPdfObject();
        if (docInfo != null) {
            for (PdfName pdfName : docInfo.keySet()) {
                String value;
                PdfName key = pdfName;
                PdfObject obj = docInfo.get(key);
                if (obj == null) continue;
                if (obj.isString()) {
                    value = ((PdfString)obj).toUnicodeString();
                } else {
                    if (!obj.isName()) continue;
                    value = ((PdfName)obj).getValue();
                }
                if (PdfName.Title.equals(key)) {
                    xmpMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", "title", "x-default", "x-default", value);
                    continue;
                }
                if (PdfName.Author.equals(key)) {
                    for (String v : value.split(",|;")) {
                        if (v.trim().length() <= 0) continue;
                        XmpMetaInfoConverter.appendArrayItemIfDoesNotExist(xmpMeta, "http://purl.org/dc/elements/1.1/", "creator", v.trim(), 1024);
                    }
                    continue;
                }
                if (PdfName.Subject.equals(key)) {
                    xmpMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", "description", "x-default", "x-default", value);
                    continue;
                }
                if (PdfName.Keywords.equals(key)) {
                    for (String v : value.split(",|;")) {
                        if (v.trim().length() <= 0) continue;
                        XmpMetaInfoConverter.appendArrayItemIfDoesNotExist(xmpMeta, "http://purl.org/dc/elements/1.1/", "subject", v.trim(), 512);
                    }
                    xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", "Keywords", value);
                    continue;
                }
                if (PdfName.Creator.equals(key)) {
                    xmpMeta.setProperty("http://ns.adobe.com/xap/1.0/", "CreatorTool", value);
                    continue;
                }
                if (PdfName.Producer.equals(key)) {
                    xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", "Producer", value);
                    continue;
                }
                if (PdfName.CreationDate.equals(key)) {
                    xmpMeta.setProperty("http://ns.adobe.com/xap/1.0/", "CreateDate", PdfDate.getW3CDate(value));
                    continue;
                }
                if (PdfName.ModDate.equals(key)) {
                    xmpMeta.setProperty("http://ns.adobe.com/xap/1.0/", "ModifyDate", PdfDate.getW3CDate(value));
                    continue;
                }
                if (!PdfName.Trapped.equals(key)) continue;
                xmpMeta.setProperty("http://ns.adobe.com/pdf/1.3/", "Trapped", value);
            }
        }
    }

    private static void appendArrayItemIfDoesNotExist(XMPMeta meta, String ns, String arrayName, String value, int arrayOption) throws XMPException {
        int currentCnt = meta.countArrayItems(ns, arrayName);
        for (int i = 0; i < currentCnt; ++i) {
            XMPProperty item = meta.getArrayItem(ns, arrayName, i + 1);
            if (!value.equals(item.getValue())) continue;
            return;
        }
        meta.appendArrayItem(ns, arrayName, new PropertyOptions(arrayOption), value, null);
    }

    private static String fetchArrayIntoString(XMPMeta meta, String ns, String arrayName) throws XMPException {
        int keywordsCnt = meta.countArrayItems(ns, arrayName);
        StringBuilder sb = null;
        for (int i = 0; i < keywordsCnt; ++i) {
            XMPProperty curKeyword = meta.getArrayItem(ns, arrayName, i + 1);
            if (sb == null) {
                sb = new StringBuilder();
            } else if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(curKeyword.getValue());
        }
        return sb != null ? sb.toString() : null;
    }
}

