/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareException;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class FlateDecodeFilter
extends MemoryLimitsAwareFilter {
    @Deprecated
    private boolean strictDecoding = false;

    public FlateDecodeFilter() {
        this(false);
    }

    @Deprecated
    public FlateDecodeFilter(boolean strictDecoding) {
        this.strictDecoding = strictDecoding;
    }

    @Deprecated
    public boolean isStrictDecoding() {
        return this.strictDecoding;
    }

    @Deprecated
    public FlateDecodeFilter setStrictDecoding(boolean strict) {
        this.strictDecoding = strict;
        return this;
    }

    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        ByteArrayOutputStream outputStream = this.enableMemoryLimitsAwareHandler(streamDictionary);
        byte[] res = FlateDecodeFilter.flateDecode(b, true, outputStream);
        if (res == null && !this.strictDecoding) {
            outputStream.reset();
            res = FlateDecodeFilter.flateDecode(b, false, outputStream);
        }
        b = FlateDecodeFilter.decodePredictor(res, decodeParams);
        return b;
    }

    public static byte[] flateDecode(byte[] in, boolean strict) {
        return FlateDecodeFilter.flateDecode(in, strict, new ByteArrayOutputStream());
    }

    private static byte[] flateDecode(byte[] in, boolean strict, ByteArrayOutputStream out) {
        ByteArrayInputStream stream = new ByteArrayInputStream(in);
        InflaterInputStream zip = new InflaterInputStream(stream);
        byte[] b = new byte[strict ? 4092 : 1];
        try {
            int n;
            while ((n = zip.read(b)) >= 0) {
                out.write(b, 0, n);
            }
            zip.close();
            out.close();
            return out.toByteArray();
        }
        catch (MemoryLimitsAwareException e) {
            throw e;
        }
        catch (Exception e) {
            if (strict) {
                return null;
            }
            return out.toByteArray();
        }
    }

    public static byte[] decodePredictor(byte[] in, PdfObject decodeParams) {
        if (decodeParams == null || decodeParams.getType() != 3) {
            return in;
        }
        PdfDictionary dic = (PdfDictionary)decodeParams;
        PdfObject obj = dic.get(PdfName.Predictor);
        if (obj == null || obj.getType() != 8) {
            return in;
        }
        int predictor = ((PdfNumber)obj).intValue();
        if (predictor < 10 && predictor != 2) {
            return in;
        }
        int width = 1;
        obj = dic.get(PdfName.Columns);
        if (obj != null && obj.getType() == 8) {
            width = ((PdfNumber)obj).intValue();
        }
        int colors = 1;
        obj = dic.get(PdfName.Colors);
        if (obj != null && obj.getType() == 8) {
            colors = ((PdfNumber)obj).intValue();
        }
        int bpc = 8;
        obj = dic.get(PdfName.BitsPerComponent);
        if (obj != null && obj.getType() == 8) {
            bpc = ((PdfNumber)obj).intValue();
        }
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(in));
        ByteArrayOutputStream fout = new ByteArrayOutputStream(in.length);
        int bytesPerPixel = colors * bpc / 8;
        int bytesPerRow = (colors * width * bpc + 7) / 8;
        byte[] curr = new byte[bytesPerRow];
        byte[] prior = new byte[bytesPerRow];
        if (predictor == 2) {
            if (bpc == 8) {
                int numRows = in.length / bytesPerRow;
                for (int row = 0; row < numRows; ++row) {
                    int rowStart = row * bytesPerRow;
                    for (int col = bytesPerPixel; col < bytesPerRow; ++col) {
                        in[rowStart + col] = (byte)(in[rowStart + col] + in[rowStart + col - bytesPerPixel]);
                    }
                }
            }
            return in;
        }
        while (true) {
            int filter;
            try {
                filter = dataStream.read();
                if (filter < 0) {
                    return fout.toByteArray();
                }
                dataStream.readFully(curr, 0, bytesPerRow);
            }
            catch (Exception e) {
                return fout.toByteArray();
            }
            switch (filter) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = bytesPerPixel; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + curr[i - bytesPerPixel]);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + prior[i]);
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < bytesPerPixel; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + (byte)(prior[i] / 2));
                    }
                    for (i = bytesPerPixel; i < bytesPerRow; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + (byte)(((curr[i - bytesPerPixel] & 0xFF) + (prior[i] & 0xFF)) / 2));
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < bytesPerPixel; ++i) {
                        int n = i;
                        curr[n] = (byte)(curr[n] + prior[i]);
                    }
                    i = bytesPerPixel;
                    while (i < bytesPerRow) {
                        int a = curr[i - bytesPerPixel] & 0xFF;
                        int b = prior[i] & 0xFF;
                        int c = prior[i - bytesPerPixel] & 0xFF;
                        int p = a + b - c;
                        int pa = Math.abs(p - a);
                        int pb = Math.abs(p - b);
                        int pc = Math.abs(p - c);
                        int ret = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                        int n = i++;
                        curr[n] = (byte)(curr[n] + (byte)ret);
                    }
                    break;
                }
                default: {
                    throw new PdfException("PNG filter unknown.");
                }
            }
            try {
                fout.write(curr);
            }
            catch (IOException i) {
                // empty catch block
            }
            byte[] tmp = prior;
            prior = curr;
            curr = tmp;
        }
    }
}

